/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import io.fabric8.kubernetes.client.dsl.LogWatch;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parser.TaskOutputParameterParser;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ShellUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandExecutor.class);
    protected volatile Map<String, String> taskOutputParams = new HashMap<String, String>();
    private Process process;
    protected Consumer<LinkedBlockingQueue<String>> logHandler;
    protected LinkedBlockingQueue<String> logBuffer;
    protected boolean processLogOutputIsSuccess = false;
    protected boolean podLogOutputIsFinished = false;
    protected TaskExecutionContext taskRequest;
    protected Future<?> taskOutputFuture;
    protected Future<?> podLogOutputFuture;

    public AbstractCommandExecutor(Consumer<LinkedBlockingQueue<String>> logHandler, TaskExecutionContext taskRequest) {
        this.logHandler = logHandler;
        this.taskRequest = taskRequest;
        this.logBuffer = new LinkedBlockingQueue();
        this.logBuffer.add("");
    }

    public TaskResponse run(IShellInterceptorBuilder iShellInterceptorBuilder, TaskCallBack taskCallBack) throws Exception {
        TaskResponse result = new TaskResponse();
        int taskInstanceId = this.taskRequest.getTaskInstanceId();
        iShellInterceptorBuilder = iShellInterceptorBuilder.shellDirectory(this.taskRequest.getExecutePath()).shellName(this.taskRequest.getTaskAppId());
        if (CollectionUtils.isNotEmpty(ShellUtils.ENV_SOURCE_LIST)) {
            ShellUtils.ENV_SOURCE_LIST.forEach(iShellInterceptorBuilder::appendSystemEnv);
        }
        if (StringUtils.isNotBlank((CharSequence)this.taskRequest.getEnvironmentConfig())) {
            iShellInterceptorBuilder.appendCustomEnvScript(this.taskRequest.getEnvironmentConfig());
        }
        if (this.taskRequest.getK8sTaskExecutionContext() != null) {
            iShellInterceptorBuilder.k8sConfigYaml(this.taskRequest.getK8sTaskExecutionContext().getConfigYaml());
        }
        iShellInterceptorBuilder.sudoMode(OSUtils.isSudoEnable());
        iShellInterceptorBuilder.runUser(this.taskRequest.getTenantCode());
        if (this.taskRequest.getCpuQuota() != null) {
            iShellInterceptorBuilder.cpuQuota(this.taskRequest.getCpuQuota());
        }
        if (this.taskRequest.getMemoryMax() != null) {
            iShellInterceptorBuilder.memoryQuota(this.taskRequest.getMemoryMax());
        }
        Object iShellInterceptor = iShellInterceptorBuilder.build();
        this.process = iShellInterceptor.execute();
        this.parseProcessOutput(this.process);
        this.collectPodLogIfNeeded();
        int processId = this.getProcessId(this.process);
        result.setProcessId(processId);
        this.taskRequest.setProcessId(processId);
        log.info("process start, process id is: {}", (Object)processId);
        long remainTime = this.getRemainTime();
        if (null != taskCallBack) {
            taskCallBack.updateTaskInstanceInfo(taskInstanceId);
        }
        boolean status = this.process.waitFor(remainTime, TimeUnit.SECONDS);
        TaskExecutionStatus kubernetesStatus = ProcessUtils.getApplicationStatus(this.taskRequest.getK8sTaskExecutionContext(), this.taskRequest.getTaskAppId());
        if (this.taskOutputFuture != null) {
            try {
                this.taskOutputFuture.get();
            }
            catch (ExecutionException e) {
                log.error("Handle task log error", (Throwable)e);
            }
        }
        if (this.podLogOutputFuture != null) {
            try {
                this.podLogOutputFuture.get();
                ProcessUtils.cancelApplication(this.taskRequest);
            }
            catch (ExecutionException e) {
                log.error("Handle pod log error", (Throwable)e);
            }
        }
        if (status && kubernetesStatus.isSuccess()) {
            result.setExitStatusCode(this.process.exitValue());
        } else {
            log.error("process has failure due to timeout kill, timeout value is:{}, timeoutStrategy is:{}", (Object)this.taskRequest.getTaskTimeout(), (Object)this.taskRequest.getTaskTimeoutStrategy());
            result.setExitStatusCode(-1);
        }
        int exitCode = this.process.exitValue();
        String exitLogMessage = 137 == exitCode || 143 == exitCode ? "process has killed." : "process has exited.";
        log.info("{} execute path:{}, processId:{} ,exitStatusCode:{} ,processWaitForStatus:{} ,processExitValue:{}", new Object[]{exitLogMessage, this.taskRequest.getExecutePath(), processId, result.getExitStatusCode(), status, exitCode});
        return result;
    }

    public Map<String, String> getTaskOutputParams() {
        return this.taskOutputParams;
    }

    public void cancelApplication() throws InterruptedException {
        if (this.process == null) {
            return;
        }
        boolean killed = ProcessUtils.kill(this.taskRequest);
        if (killed) {
            log.info("Process tree for task: {} is killed or already finished, pid: {}", (Object)this.taskRequest.getTaskAppId(), (Object)this.taskRequest.getProcessId());
        } else {
            log.error("Failed to kill process tree for task: {}, pid: {}", (Object)this.taskRequest.getTaskAppId(), (Object)this.taskRequest.getProcessId());
        }
        ProcessUtils.cancelApplication(this.taskRequest);
    }

    private void collectPodLogIfNeeded() {
        if (null == this.taskRequest.getK8sTaskExecutionContext()) {
            this.podLogOutputIsFinished = true;
            return;
        }
        ScheduledExecutorService collectPodLogExecutorService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("CollectPodLogOutput-thread-" + this.taskRequest.getTaskName()));
        this.podLogOutputFuture = collectPodLogExecutorService.submit(() -> {
            ThreadUtils.sleep((long)5000L);
            try (LogWatch watcher = ProcessUtils.getPodLogWatcher(this.taskRequest.getK8sTaskExecutionContext(), this.taskRequest.getTaskAppId(), "");){
                if (watcher == null) {
                    throw new RuntimeException("The driver pod does not exist.");
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(watcher.getOutput()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        this.logBuffer.add(String.format("[K8S-pod-log-%s]: %s", this.taskRequest.getTaskName(), line));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.podLogOutputIsFinished = true;
            }
        });
        collectPodLogExecutorService.shutdown();
    }

    private void parseProcessOutput(Process process) {
        ScheduledExecutorService getOutputLogService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("ResolveOutputLog-thread-" + this.taskRequest.getTaskName()));
        getOutputLogService.execute(() -> {
            TaskOutputParameterParser taskOutputParameterParser = new TaskOutputParameterParser();
            try (BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                LogUtils.setTaskInstanceLogFullPathMDC(this.taskRequest.getLogPath());
                while ((line = inReader.readLine()) != null) {
                    this.logBuffer.add(line);
                    taskOutputParameterParser.appendParseLog(line);
                }
                this.processLogOutputIsSuccess = true;
            }
            catch (Exception e) {
                log.error("Parse var pool error", (Throwable)e);
                this.processLogOutputIsSuccess = true;
            }
            finally {
                LogUtils.removeTaskInstanceLogFullPathMDC();
            }
            this.taskOutputParams = taskOutputParameterParser.getTaskOutputParams();
        });
        getOutputLogService.shutdown();
        ScheduledExecutorService parseProcessOutputExecutorService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("TaskInstanceLogOutput-thread-" + this.taskRequest.getTaskName()));
        this.taskOutputFuture = parseProcessOutputExecutorService.submit(() -> {
            try {
                LogUtils.setTaskInstanceLogFullPathMDC(this.taskRequest.getLogPath());
                while (this.logBuffer.size() > 1 || !this.processLogOutputIsSuccess || !this.podLogOutputIsFinished) {
                    if (this.logBuffer.size() > 1) {
                        this.logHandler.accept(this.logBuffer);
                        this.logBuffer.clear();
                        this.logBuffer.add("");
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                log.error("Output task log error", (Throwable)e);
            }
            finally {
                LogUtils.removeTaskInstanceLogFullPathMDC();
            }
        });
        parseProcessOutputExecutorService.shutdown();
    }

    private long getRemainTime() {
        long usedTime = (System.currentTimeMillis() - this.taskRequest.getStartTime()) / 1000L;
        long remainTime = (long)this.taskRequest.getTaskTimeout() - usedTime;
        if (remainTime < 0L) {
            throw new RuntimeException("task execution time out");
        }
        return remainTime;
    }

    private int getProcessId(Process process) {
        int processId = 0;
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            processId = f.getInt(process);
        }
        catch (Exception e) {
            log.error("Get task pid failed", (Throwable)e);
        }
        return processId;
    }
}

