/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.bucketcertificate.BucketDomainCertificateInfo;
import com.qcloud.cos.model.bucketcertificate.BucketGetDomainCertificate;
import com.qcloud.cos.model.bucketcertificate.BucketPutDomainCertificate;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;

public class BucketCertificateDemo {
    public static void main(String[] args) {
        BucketCertificateDemo.putGetDeleteBucketCertificate();
    }

    private static void putGetDeleteBucketCertificate() {
        BasicCOSCredentials cred = new BasicCOSCredentials("xxxxxxxxxxxxxxxxxxxxxxxxxxxx", "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing"));
        String bucketName = "mybucket-12500000000";
        BucketPutDomainCertificate bucketPutDomainCertificate = new BucketPutDomainCertificate();
        BucketDomainCertificateInfo bucketDomainCertificateInfo = new BucketDomainCertificateInfo();
        bucketDomainCertificateInfo.setCertType("CustomCert");
        LinkedList<String> domainlist = new LinkedList<String>();
        domainlist.add("test.com");
        bucketPutDomainCertificate.setDomainList(domainlist);
        try {
            String key = BucketCertificateDemo.getStreamContent("src/test/resources/test.com.key");
            bucketDomainCertificateInfo.setPrivateKey(key);
            String pem = BucketCertificateDemo.getStreamContent("src/test/resources/test.com.pem");
            bucketDomainCertificateInfo.setCert(pem);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        COSClient cosclient = new COSClient(cred, clientConfig);
        bucketPutDomainCertificate.setBucketDomainCertificateInfo(bucketDomainCertificateInfo);
        cosclient.setBucketDomainCertificate(bucketName, bucketPutDomainCertificate);
        BucketGetDomainCertificate domainCertificate = cosclient.getBucketDomainCertificate(bucketName, "test.com");
        System.out.println(domainCertificate.getStatus());
        cosclient.deleteBucketDomainCertificate(bucketName, "test.com");
        cosclient.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamContent(String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, StringUtils.UTF8));
        try {
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                stringBuilder.append(buf, 0, read);
            }
        }
        finally {
            ((InputStream)is).close();
            br.close();
        }
        return stringBuilder.toString();
    }
}

