/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.crypto.CryptoCipher;
import com.aliyun.oss.crypto.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class CipherInputStream
extends SdkFilterInputStream {
    private static final int MAX_RETRY = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 512;
    private CryptoCipher cryptoCipher;
    private boolean eof;
    private byte[] bufin;
    private byte[] bufout;
    private int curr_pos;
    private int max_pos;

    public CipherInputStream(InputStream is, CryptoCipher cryptoCipher) {
        this(is, cryptoCipher, 512);
    }

    public CipherInputStream(InputStream is, CryptoCipher c, int buffsize) {
        super(is);
        this.cryptoCipher = c;
        if (buffsize <= 0 || buffsize % 512 != 0) {
            throw new IllegalArgumentException("buffsize (" + buffsize + ") must be a positive multiple of " + 512);
        }
        this.bufin = new byte[buffsize];
    }

    @Override
    public int read() throws IOException {
        if (this.curr_pos >= this.max_pos) {
            int len;
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
            if (len == -1) {
                return -1;
            }
        }
        return this.bufout[this.curr_pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int target_len) throws IOException {
        if (this.curr_pos >= this.max_pos) {
            int len;
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
            if (len == -1) {
                return -1;
            }
        }
        if (target_len <= 0) {
            return 0;
        }
        int len = this.max_pos - this.curr_pos;
        if (target_len < len) {
            len = target_len;
        }
        System.arraycopy(this.bufout, this.curr_pos, buf, off, len);
        this.curr_pos += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        int available = this.max_pos - this.curr_pos;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.curr_pos = (int)((long)this.curr_pos + n);
        return n;
    }

    @Override
    public int available() {
        this.abortIfNeeded();
        return this.max_pos - this.curr_pos;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        try {
            this.cryptoCipher.doFinal();
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        this.max_pos = 0;
        this.curr_pos = 0;
        this.abortIfNeeded();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return false;
    }

    @Override
    public void mark(int readlimit) {
        this.abortIfNeeded();
    }

    @Override
    public void reset() throws IOException {
        throw new IllegalStateException("mark/reset not supported.");
    }

    final void resetInternal() {
        this.max_pos = 0;
        this.curr_pos = 0;
        this.eof = false;
    }

    private int nextChunk() throws IOException {
        this.abortIfNeeded();
        if (this.eof) {
            return -1;
        }
        this.bufout = null;
        int len = this.in.read(this.bufin);
        if (len == -1) {
            this.eof = true;
            try {
                this.bufout = this.cryptoCipher.doFinal();
                if (this.bufout == null) {
                    return -1;
                }
                this.curr_pos = 0;
                this.max_pos = this.bufout.length;
                return this.max_pos;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
            }
            catch (BadPaddingException e) {
                throw new SecurityException(e);
            }
            return -1;
        }
        this.bufout = this.cryptoCipher.update(this.bufin, 0, len);
        this.curr_pos = 0;
        this.max_pos = this.bufout == null ? 0 : this.bufout.length;
        return this.max_pos;
    }

    void renewCryptoCipher() {
        this.cryptoCipher = this.cryptoCipher.recreate();
    }
}

