/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractModel {
    private HashMap<String, Object> customizedParams = new HashMap();

    protected abstract void toMap(HashMap<String, String> var1, String var2);

    protected String[] getBinaryParams() {
        return new String[0];
    }

    protected HashMap<String, byte[]> getMultipartRequestParams() {
        return new HashMap<String, byte[]>();
    }

    protected <V> void setParamSimple(HashMap<String, String> map, String key, V value) {
        if (value != null) {
            key = key.substring(0, 1).toUpperCase() + key.substring(1);
            key = key.replace("_", ".");
            map.put(key, String.valueOf(value));
        }
    }

    protected <V> void setParamArraySimple(HashMap<String, String> map, String prefix, V[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                this.setParamSimple(map, prefix + i, array[i]);
            }
        }
    }

    protected <V extends AbstractModel> void setParamObj(HashMap<String, String> map, String prefix, V obj) {
        if (obj != null) {
            obj.toMap(map, prefix);
        }
    }

    protected <V extends AbstractModel> void setParamArrayObj(HashMap<String, String> map, String prefix, V[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                this.setParamObj(map, prefix + i + ".", array[i]);
            }
        }
    }

    public static <O extends AbstractModel> String toJsonString(O obj) {
        return AbstractModel.toJsonObject(obj).toString();
    }

    private static <O extends AbstractModel> JsonObject toJsonObject(O obj) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        JsonObject joall = new JsonObject();
        JsonObject joadd = gson.toJsonTree(obj.any()).getAsJsonObject();
        for (Map.Entry entry : joadd.entrySet()) {
            joall.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        JsonObject jopublic = gson.toJsonTree(obj).getAsJsonObject();
        for (Map.Entry entry : jopublic.entrySet()) {
            Object fo = null;
            try {
                Field f = obj.getClass().getDeclaredField((String)entry.getKey());
                f.setAccessible(true);
                fo = f.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fo instanceof AbstractModel) {
                joall.add((String)entry.getKey(), (JsonElement)AbstractModel.toJsonObject((AbstractModel)fo));
                continue;
            }
            joall.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return joall;
    }

    public static <O> O fromJsonString(String json, Class<O> cls) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return (O)gson.fromJson(json, cls);
    }

    public void set(String key, Object value) {
        this.customizedParams.put(key, value);
    }

    public HashMap<String, Object> any() {
        return this.customizedParams;
    }
}

