/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.workflow;

import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.validator.IValidator;
import org.apache.dolphinscheduler.api.validator.workflow.BackfillWorkflowDTO;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackfillWorkflowDTOValidator
implements IValidator<BackfillWorkflowDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackfillWorkflowDTOValidator.class);

    @Override
    public void validate(BackfillWorkflowDTO backfillWorkflowDTO) {
        BackfillWorkflowDTO.BackfillParamsDTO backfillParams = backfillWorkflowDTO.getBackfillParams();
        if (backfillParams == null) {
            throw new IllegalArgumentException("backfillParams is null");
        }
        if (CollectionUtils.isEmpty(backfillParams.getBackfillDateList())) {
            throw new IllegalArgumentException("backfillDateList is empty");
        }
        if (backfillParams.getExpectedParallelismNumber() < 0) {
            throw new IllegalArgumentException("expectedParallelismNumber should >= 0");
        }
        if (backfillWorkflowDTO.getExecType() != CommandType.COMPLEMENT_DATA) {
            throw new IllegalArgumentException("The execType should be START_PROCESS");
        }
        if (backfillWorkflowDTO.getWorkflowDefinition() == null) {
            throw new IllegalArgumentException("The workflowDefinition should not be null");
        }
        if (backfillWorkflowDTO.getWorkflowDefinition().getReleaseState() != ReleaseState.ONLINE) {
            throw new IllegalStateException("The workflowDefinition should be online");
        }
    }
}

