/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.fluent.models.DeploymentResourceInner;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceStatus;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.io.File;
import java.util.List;
import reactor.core.publisher.Mono;

public interface SpringAppDeployment
extends ExternalChildResource<SpringAppDeployment, SpringApp>,
HasInnerModel<DeploymentResourceInner>,
Updatable<Update> {
    public String appName();

    public DeploymentSettings settings();

    public DeploymentResourceStatus status();

    public boolean isActive();

    public List<DeploymentInstance> instances();

    public void start();

    public Mono<Void> startAsync();

    public void stop();

    public Mono<Void> stopAsync();

    public void restart();

    public Mono<Void> restartAsync();

    public String getLogFileUrl();

    public Mono<String> getLogFileUrlAsync();

    public List<String> configFilePatterns();

    public Double cpu();

    public Double memoryInGB();

    public RuntimeVersion runtimeVersion();

    public String jvmOptions();

    public static interface UpdateStages {

        public static interface WithModule {
            public Update withTargetModule(String var1);

            public Update withSingleModule();
        }

        public static interface WithSource {
            public Update withJarFile(File var1);

            public Update withJarFile(File var1, List<String> var2);

            public WithModule withSourceCodeTarGzFile(File var1);

            public WithModule withSourceCodeTarGzFile(File var1, List<String> var2);

            public Update withExistingSource(UserSourceType var1, String var2);
        }

        public static interface WithSettings {
            public Update withInstance(int var1);

            public Update withCpu(int var1);

            public Update withCpu(double var1);

            public Update withMemory(int var1);

            public Update withMemory(double var1);

            public Update withRuntime(RuntimeVersion var1);

            public Update withJvmOptions(String var1);

            public Update withEnvironment(String var1, String var2);

            public Update withoutEnvironment(String var1);

            public Update withVersionName(String var1);

            public Update withActivation();

            public Update withConfigFilePatterns(List<String> var1);
        }
    }

    public static interface Update
    extends Appliable<SpringAppDeployment>,
    UpdateStages.WithSource,
    UpdateStages.WithModule,
    UpdateStages.WithSettings {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT, T>
        extends Attachable<ParentT>,
        Final<T> {
        }

        public static interface WithCreate<T>
        extends Creatable<SpringAppDeployment>,
        Final<T> {
        }

        public static interface Final<T>
        extends WithSettings<T> {
        }

        public static interface WithSettings<T> {
            public T withInstance(int var1);

            public T withCpu(int var1);

            public T withCpu(double var1);

            public T withMemory(int var1);

            public T withMemory(double var1);

            public T withRuntime(RuntimeVersion var1);

            public T withJvmOptions(String var1);

            public T withEnvironment(String var1, String var2);

            public T withVersionName(String var1);

            public T withActivation();

            public T withConfigFilePatterns(List<String> var1);
        }

        public static interface WithModule<T> {
            public T withTargetModule(String var1);

            public T withSingleModule();
        }

        public static interface WithSource<T> {
            public T withJarFile(File var1);

            public T withJarFile(File var1, List<String> var2);

            public WithModule<T> withSourceCodeTarGzFile(File var1);

            public WithModule<T> withSourceCodeTarGzFile(File var1, List<String> var2);

            public T withExistingSource(UserSourceType var1, String var2);
        }

        public static interface Blank<T>
        extends WithSource<T> {
        }
    }

    public static interface Definition<ParentT, T>
    extends DefinitionStages.Blank<T>,
    DefinitionStages.WithSource<T>,
    DefinitionStages.WithModule<T>,
    DefinitionStages.WithCreate<T>,
    DefinitionStages.WithAttach<ParentT, T> {
    }
}

