/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class LongMean
implements LongStatistic,
StatisticAccumulator<LongMean> {
    private static final long SMALL_SUM = 0x20000000000000L;
    private final Int128 sum;
    private long n;

    private LongMean() {
        this(Int128.create(), 0);
    }

    private LongMean(Int128 sum, int n) {
        this.sum = sum;
        this.n = n;
    }

    public static LongMean create() {
        return new LongMean();
    }

    public static LongMean of(long ... values) {
        Int128 s = Int128.create();
        for (long x : values) {
            s.add(x);
        }
        return new LongMean(s, values.length);
    }

    public static LongMean ofRange(long[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return LongMean.createFromRange(values, from, to);
    }

    static LongMean createFromRange(long[] values, int from, int to) {
        Int128 s = Int128.create();
        for (int i = from; i < to; ++i) {
            s.add(values[i]);
        }
        return new LongMean(s, to - from);
    }

    @Override
    public void accept(long value) {
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return LongMean.computeMean(this.sum, this.n);
    }

    static double computeMean(Int128 sum, long n) {
        if (sum.hi64() == 0L && Math.abs(sum.lo64()) < 0x20000000000000L) {
            return (double)sum.lo64() / (double)n;
        }
        return sum.divideToDouble(n);
    }

    @Override
    public LongMean combine(LongMean other) {
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }
}

