/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.DistributionException;

public final class LogisticDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = Double.NEGATIVE_INFINITY;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double PI_SQUARED_OVER_THREE = 3.289868133696453;
    private final double mu;
    private final double scale;
    private final double logScale;

    private LogisticDistribution(double mu, double scale) {
        this.mu = mu;
        this.scale = scale;
        this.logScale = Math.log(scale);
    }

    public static LogisticDistribution of(double mu, double scale) {
        if (scale <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", scale);
        }
        return new LogisticDistribution(mu, scale);
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x <= Double.NEGATIVE_INFINITY || x >= Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double z = -Math.abs(x - this.mu) / this.scale;
        double v = Math.exp(z);
        return v / ((1.0 + v) * (1.0 + v)) / this.scale;
    }

    @Override
    public double logDensity(double x) {
        if (x <= Double.NEGATIVE_INFINITY || x >= Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double z = -Math.abs(x - this.mu) / this.scale;
        double v = Math.exp(z);
        return z - 2.0 * Math.log1p(v) - this.logScale;
    }

    @Override
    public double cumulativeProbability(double x) {
        double z = (x - this.mu) / this.scale;
        return 1.0 / (1.0 + Math.exp(-z));
    }

    @Override
    public double survivalProbability(double x) {
        double z = (x - this.mu) / this.scale;
        return 1.0 / (1.0 + Math.exp(z));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * Math.log(p / (1.0 - p)) + this.mu;
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * -Math.log(p / (1.0 - p)) + this.mu;
    }

    @Override
    public double getMean() {
        return this.getLocation();
    }

    @Override
    public double getVariance() {
        return this.scale * this.scale * 3.289868133696453;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    double getMedian() {
        return this.mu;
    }
}

