/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.SumOfLogs;

public final class GeometricMean
implements DoubleStatistic,
StatisticAccumulator<GeometricMean> {
    private long n;
    private final SumOfLogs sumOfLogs;

    private GeometricMean() {
        this(SumOfLogs.create(), 0L);
    }

    private GeometricMean(SumOfLogs sumOfLogs, long n) {
        this.sumOfLogs = sumOfLogs;
        this.n = n;
    }

    public static GeometricMean create() {
        return new GeometricMean();
    }

    public static GeometricMean of(double ... values) {
        return new GeometricMean(SumOfLogs.of(values), values.length);
    }

    public static GeometricMean ofRange(double[] values, int from, int to) {
        return new GeometricMean(SumOfLogs.ofRange(values, from, to), to - from);
    }

    public static GeometricMean of(int ... values) {
        return new GeometricMean(SumOfLogs.of(values), values.length);
    }

    public static GeometricMean ofRange(int[] values, int from, int to) {
        return new GeometricMean(SumOfLogs.ofRange(values, from, to), to - from);
    }

    public static GeometricMean of(long ... values) {
        return new GeometricMean(SumOfLogs.of(values), values.length);
    }

    public static GeometricMean ofRange(long[] values, int from, int to) {
        return new GeometricMean(SumOfLogs.ofRange(values, from, to), to - from);
    }

    @Override
    public void accept(double value) {
        ++this.n;
        this.sumOfLogs.accept(value);
    }

    @Override
    public double getAsDouble() {
        return GeometricMean.computeGeometricMean(this.n, this.sumOfLogs);
    }

    @Override
    public GeometricMean combine(GeometricMean other) {
        this.n += other.n;
        this.sumOfLogs.combine(other.sumOfLogs);
        return this;
    }

    static double computeGeometricMean(long n, SumOfLogs sumOfLogs) {
        return n == 0L ? Double.NaN : Math.exp(sumOfLogs.getAsDouble() / (double)n);
    }
}

