/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import org.apache.cayenne.access.types.ValueObjectType;

public class CharacterValueType
implements ValueObjectType<Character, String> {
    @Override
    public Class<String> getTargetType() {
        return String.class;
    }

    @Override
    public Class<Character> getValueType() {
        return Character.class;
    }

    @Override
    public Character toJavaObject(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return Character.valueOf('\u0000');
        }
        if (value.length() > 1) {
            throw new IllegalArgumentException("Only one char String can be used, " + value + " used");
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public String fromJavaObject(Character object) {
        return String.valueOf(object);
    }

    @Override
    public String toCacheKey(Character object) {
        return String.valueOf(object);
    }
}

