/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.github.jamm.MemoryMeter;
import org.github.jamm.MemoryMeterStrategy;
import org.github.jamm.utils.ArrayMeasurementUtils;

public class ObjectSizes {
    private static final MemoryMeter meter = MemoryMeter.builder().withGuessing(MemoryMeter.Guess.INSTRUMENTATION_AND_SPECIFICATION, new MemoryMeter.Guess[]{MemoryMeter.Guess.UNSAFE}).build();
    private static final long HEAP_BUFFER_SHALLOW_SIZE = ObjectSizes.measure(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    private static final long DIRECT_BUFFER_SHALLOW_SIZE = ObjectSizes.measure(ByteBuffer.allocateDirect(0));
    private static final long DIRECT_BUFFER_DEEP_SIZE = ObjectSizes.measureDeep(ByteBuffer.allocateDirect(0));
    public static final long IPV6_SOCKET_ADDRESS_SIZE = ObjectSizes.measureDeep(new InetSocketAddress(ObjectSizes.getIpvAddress(16), 42));

    public static long sizeOfArray(byte[] bytes) {
        return meter.measureArray(bytes);
    }

    public static long sizeOfArray(long[] longs) {
        return meter.measureArray(longs);
    }

    public static long sizeOfArray(int[] ints) {
        return meter.measureArray(ints);
    }

    public static long sizeOfReferenceArray(int length) {
        return ObjectSizes.sizeOfArray(length, MemoryMeterStrategy.MEMORY_LAYOUT.getReferenceSize());
    }

    public static long sizeOfArray(Object[] objects) {
        return meter.measureArray(objects);
    }

    private static long sizeOfArray(int length, int elementSize) {
        return ArrayMeasurementUtils.computeArraySize((int)MemoryMeterStrategy.MEMORY_LAYOUT.getArrayHeaderSize(), (int)length, (int)elementSize, (int)MemoryMeterStrategy.MEMORY_LAYOUT.getObjectAlignment());
    }

    public static long sizeOnHeapOf(ByteBuffer[] array) {
        if (array == null) {
            return 0L;
        }
        long sum = ObjectSizes.sizeOfArray(array);
        for (ByteBuffer buffer : array) {
            sum += ObjectSizes.sizeOnHeapOf(buffer);
        }
        return sum;
    }

    public static long sizeOnHeapExcludingDataOf(ByteBuffer[] array) {
        if (array == null) {
            return 0L;
        }
        long sum = ObjectSizes.sizeOfArray(array);
        for (ByteBuffer b : array) {
            sum += ObjectSizes.sizeOnHeapExcludingDataOf(b);
        }
        return sum;
    }

    public static long sizeOnHeapOf(ByteBuffer buffer) {
        if (buffer == null) {
            return 0L;
        }
        assert (!buffer.isReadOnly());
        if (MemoryMeter.ByteBufferMode.SLAB_ALLOCATION_NO_SLICE.isSlab(buffer)) {
            if (buffer.isDirect()) {
                return DIRECT_BUFFER_SHALLOW_SIZE;
            }
            return HEAP_BUFFER_SHALLOW_SIZE + (long)buffer.remaining();
        }
        if (buffer.isDirect()) {
            return DIRECT_BUFFER_DEEP_SIZE;
        }
        return HEAP_BUFFER_SHALLOW_SIZE + meter.measureArray(buffer.array());
    }

    public static long sizeOnHeapExcludingDataOf(ByteBuffer buffer) {
        if (buffer == null) {
            return 0L;
        }
        assert (!buffer.isReadOnly());
        if (MemoryMeter.ByteBufferMode.SLAB_ALLOCATION_NO_SLICE.isSlab(buffer)) {
            if (buffer.isDirect()) {
                return DIRECT_BUFFER_SHALLOW_SIZE;
            }
            return HEAP_BUFFER_SHALLOW_SIZE;
        }
        if (buffer.isDirect()) {
            return DIRECT_BUFFER_DEEP_SIZE;
        }
        byte[] bytes = buffer.array();
        return HEAP_BUFFER_SHALLOW_SIZE + meter.measureArray(bytes) - (long)bytes.length;
    }

    public static long sizeOf(String str) {
        return meter.measureStringDeep(str);
    }

    public static long measureDeep(Object pojo) {
        return meter.measureDeep(pojo);
    }

    public static long measureDeepOmitShared(Object pojo) {
        return meter.measureDeep(pojo, MemoryMeter.ByteBufferMode.SLAB_ALLOCATION_NO_SLICE);
    }

    public static long measure(Object pojo) {
        return meter.measure(pojo);
    }

    private static InetAddress getIpvAddress(int size) {
        if (size == 16 || size == 4) {
            try {
                return InetAddress.getByAddress(new byte[size]);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid size of a byte array when getting and ipv address: " + size);
            }
        }
        throw new IllegalArgumentException("Excpected a byte array size of 4 or 16 for an ipv address but got: " + size);
    }
}

