/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ChecksumType;

public class DataIntegrityMetadata {

    public static class FileDigestValidator {
        private final Checksum checksum;
        private final File dataFile;
        private final File digestFile;

        public FileDigestValidator(File dataFile, File digestFile) throws IOException {
            this.dataFile = dataFile;
            this.digestFile = digestFile;
            this.checksum = ChecksumType.CRC32.newInstance();
        }

        public void validate() throws IOException {
            try (RandomAccessReader digestReader = RandomAccessReader.open(this.digestFile);
                 RandomAccessReader dataReader = RandomAccessReader.open(this.dataFile);
                 CheckedInputStream checkedInputStream = new CheckedInputStream(dataReader, this.checksum);){
                long storedDigestValue = Long.parseLong(digestReader.readLine());
                byte[] chunk = new byte[65536];
                while (checkedInputStream.read(chunk) > 0) {
                }
                long calculatedDigestValue = checkedInputStream.getChecksum().getValue();
                if (storedDigestValue != calculatedDigestValue) {
                    throw new IOException(String.format("Corrupted file: integrity check (digest) failed for %s: %d != %d", this.dataFile, storedDigestValue, calculatedDigestValue));
                }
            }
        }
    }

    public static class ChecksumValidator
    implements Closeable {
        private final ChecksumType checksumType;
        private final RandomAccessReader reader;
        public final int chunkSize;

        public ChecksumValidator(File dataFile, File crcFile) throws IOException {
            this(ChecksumType.CRC32, RandomAccessReader.open(crcFile), dataFile.absolutePath());
        }

        public ChecksumValidator(ChecksumType checksumType, RandomAccessReader reader, String dataFilename) throws IOException {
            this.checksumType = checksumType;
            this.reader = reader;
            this.chunkSize = reader.readInt();
        }

        public void seek(long offset) {
            long start = this.chunkStart(offset);
            this.reader.seek(start / (long)this.chunkSize * 4L + 4L);
        }

        public long chunkStart(long offset) {
            long startChunk = offset / (long)this.chunkSize;
            return startChunk * (long)this.chunkSize;
        }

        public void validate(byte[] bytes, int start, int end) throws IOException {
            int storedValue;
            int calculatedValue = (int)this.checksumType.of(bytes, start, end);
            if (calculatedValue != (storedValue = this.reader.readInt())) {
                throw new IOException(String.format("Corrupted file: integrity check (%s) failed for %s: %d != %d", this.checksumType.name(), this.reader.getPath(), storedValue, calculatedValue));
            }
        }

        public void validate(ByteBuffer buffer) throws IOException {
            int storedValue;
            int calculatedValue = (int)this.checksumType.of(buffer);
            if (calculatedValue != (storedValue = this.reader.readInt())) {
                throw new IOException(String.format("Corrupted file: integrity check (%s) failed for %s: %d != %d", this.checksumType.name(), this.reader.getPath(), storedValue, calculatedValue));
            }
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

