/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SaslSuperUserTest
extends ClientBase {
    private static Id otherSaslUser = new Id("sasl", "joe");
    private static Id otherDigestUser;
    private static String oldAuthProvider;
    private static String oldClientConfigSection;
    private static String oldLoginConfig;
    private static String oldSuperUser;
    private AtomicInteger authFailed = new AtomicInteger(0);

    @BeforeAll
    public static void setupStatic() throws Exception {
        oldAuthProvider = System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        oldClientConfigSection = System.getProperty("zookeeper.sasl.clientconfig");
        File tmpDir = SaslSuperUserTest.createTmpDir();
        File saslConfFile = new File(tmpDir, "jaas.conf");
        FileWriter fwriter = new FileWriter(saslConfFile);
        fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super_duper=\"test\"\n          user_other_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super_duper\"\n       password=\"test\";\n};OtherClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"other_super\"\n       password=\"test\";\n};\n");
        fwriter.close();
        oldLoginConfig = System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        oldSuperUser = System.setProperty("zookeeper.superUser", "super_duper");
        otherDigestUser = new Id("digest", DigestAuthenticationProvider.generateDigest((String)"jack:jack"));
    }

    @AfterAll
    public static void cleanupStatic() {
        SaslSuperUserTest.restoreProperty("zookeeper.authProvider.1", oldAuthProvider);
        SaslSuperUserTest.restoreProperty("zookeeper.sasl.clientconfig", oldClientConfigSection);
        SaslSuperUserTest.restoreProperty("java.security.auth.login.config", oldLoginConfig);
        SaslSuperUserTest.restoreProperty("zookeeper.superUser", oldSuperUser);
    }

    private static void restoreProperty(String property, String oldValue) {
        if (oldValue != null) {
            System.setProperty(property, oldValue);
        } else {
            System.clearProperty(property);
        }
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    private void connectAndPerformSuperOps() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/digest_read", null, Arrays.asList(new ACL(1, otherDigestUser)), CreateMode.PERSISTENT);
            zk.create("/digest_read/sub", null, Arrays.asList(new ACL(1, otherDigestUser)), CreateMode.PERSISTENT);
            zk.create("/sasl_read", null, Arrays.asList(new ACL(1, otherSaslUser)), CreateMode.PERSISTENT);
            zk.create("/sasl_read/sub", null, Arrays.asList(new ACL(1, otherSaslUser)), CreateMode.PERSISTENT);
            zk.delete("/digest_read/sub", -1);
            zk.delete("/digest_read", -1);
            zk.delete("/sasl_read/sub", -1);
            zk.delete("/sasl_read", -1);
        }
    }

    @Test
    public void testSuperIsSuper() throws Exception {
        this.connectAndPerformSuperOps();
        Assertions.assertEquals((int)this.authFailed.get(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherSuperIsSuper() throws Exception {
        String prevSection = System.setProperty("zookeeper.sasl.clientconfig", "OtherClient");
        String superUser1Prop = "zookeeper.superUser.1";
        String prevSuperUser1 = System.setProperty(superUser1Prop, "other_super");
        try {
            this.connectAndPerformSuperOps();
            Assertions.assertEquals((int)this.authFailed.get(), (int)0);
        }
        finally {
            SaslSuperUserTest.restoreProperty(superUser1Prop, prevSuperUser1);
            SaslSuperUserTest.restoreProperty("zookeeper.sasl.clientconfig", prevSection);
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslSuperUserTest.this.authFailed.incrementAndGet();
            } else {
                super.process(event);
            }
        }
    }
}

