/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.io.File;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.util.VerifyingFileFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyingFileFactoryTest
extends ZKTestCase {
    private Logger log;

    @BeforeEach
    public void setUp() {
        this.log = LoggerFactory.getLogger((String)"TODO: Mock Logging");
    }

    @Test
    public void testForWarningOnRelativePath() {
        VerifyingFileFactory vff = new VerifyingFileFactory.Builder(this.log).warnForRelativePath().build();
        vff.create("a/relative/path");
    }

    @Test
    public void testForNoWarningOnIntendedRelativePath() {
        VerifyingFileFactory vff = new VerifyingFileFactory.Builder(this.log).warnForRelativePath().build();
        vff.create("./an/intended/relative/path");
    }

    @Test
    public void testForFailForNonExistingPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            VerifyingFileFactory vff = new VerifyingFileFactory.Builder(this.log).failForNonExistingPath().build();
            vff.create("/I/H0p3/this/path/d035/n0t/ex15t");
        });
    }

    @Test
    public void testFileHasCorrectPath() {
        File file = new File("/some/path");
        VerifyingFileFactory vff = new VerifyingFileFactory.Builder(this.log).build();
        Assertions.assertEquals((Object)file, (Object)vff.create(file.getPath()));
    }
}

