/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeTest
extends ClientBase {
    private static final long mt0 = System.currentTimeMillis();
    private static final long nt0 = Time.currentElapsedTime();
    private static AtomicInteger watchCount = new AtomicInteger(0);

    public static void main(String[] args) throws Exception {
        System.out.print("Starting\n");
        TimeTest test = new TimeTest();
        System.out.print("After construct\n");
        test.setUp();
        TestableZooKeeper zk = test.createClient();
        zk.create("/ephemeral", new byte[]{1, 2, 3}, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        while (Time.currentElapsedTime() - nt0 < 100000L) {
            System.out.printf("%d\t%s\n", TimeTest.discrepancy(), zk.exists("/ephemeral", (Watcher)(watchCount.get() == 0 ? TimeTest.createWatcher() : null)) != null);
            TimeTest.waitByYielding(500L);
        }
    }

    private static Watcher createWatcher() {
        watchCount.incrementAndGet();
        return event -> {
            watchCount.decrementAndGet();
            System.out.printf("%d event = %s\n", TimeTest.discrepancy(), event);
        };
    }

    private static void waitByYielding(long delay) {
        long t0 = Time.currentElapsedTime();
        while (Time.currentElapsedTime() < t0 + delay) {
            Thread.yield();
        }
    }

    private static long discrepancy() {
        return System.currentTimeMillis() - mt0 - (Time.currentElapsedTime() - nt0);
    }

    @Test
    public void testElapsedTimeToDate() throws Exception {
        long walltime = Time.currentWallTime();
        long elapsedTime = Time.currentElapsedTime();
        Thread.sleep(200L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(Time.elapsedTimeToDate((long)elapsedTime));
        int calculatedDate = cal.get(11);
        cal.setTime(new Date(walltime));
        int realDate = cal.get(11);
        Assertions.assertEquals((int)calculatedDate, (int)realDate);
    }
}

