/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKCS5S1ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Digest digest;

    public PKCS5S1ParametersGenerator(T t, Digest digest) {
        super(t);
        this.digest = digest;
    }

    private byte[] generateDerivedKey() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.update(this.password, 0, this.password.length);
        this.digest.update(this.salt, 0, this.salt.length);
        this.digest.doFinal(byArray, 0);
        for (int i = 1; i < this.iterationCount; ++i) {
            this.digest.update(byArray, 0, byArray.length);
            this.digest.doFinal(byArray, 0);
        }
        return byArray;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n) {
        if ((n /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + n + " bytes long.");
        }
        byte[] byArray = this.generateDerivedKey();
        return new KeyParameterImpl(Arrays.copyOfRange(byArray, 0, n));
    }

    @Override
    public CipherParameters generateDerivedParameters(int n, int n2) {
        if ((n /= 8) + (n2 /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + (n + n2) + " bytes long.");
        }
        byte[] byArray = this.generateDerivedKey();
        return new ParametersWithIV(new KeyParameterImpl(Arrays.copyOfRange(byArray, 0, n)), byArray, n, n2);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n) {
        return this.generateDerivedParameters(n);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
        return ((KeyParameter)this.generateDerivedParameters(n * 8)).getKey();
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        ParametersWithIV parametersWithIV = (ParametersWithIV)this.generateDerivedParameters(n * 8, n2 * 8);
        byte[][] byArrayArray = new byte[][]{((KeyParameter)parametersWithIV.getParameters()).getKey(), parametersWithIV.getIV()};
        return byArrayArray;
    }
}

