/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import io.prometheus.client.Collector;
import io.prometheus.client.Predicate;
import io.prometheus.client.SummaryMetricFamily;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GarbageCollectorExports
extends Collector {
    private static final String JVM_GC_COLLECTION_SECONDS = "jvm_gc_collection_seconds";
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectorExports() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    GarbageCollectorExports(List<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = garbageCollectors;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (nameFilter == null || nameFilter.test((Object)JVM_GC_COLLECTION_SECONDS)) {
            SummaryMetricFamily gcCollection = new SummaryMetricFamily(JVM_GC_COLLECTION_SECONDS, "Time spent in a given JVM garbage collector in seconds.", Collections.singletonList("gc"));
            for (GarbageCollectorMXBean gc : this.garbageCollectors) {
                gcCollection.addMetric(Collections.singletonList(gc.getName()), (double)gc.getCollectionCount(), (double)gc.getCollectionTime() / 1000.0);
            }
            mfs.add((Collector.MetricFamilySamples)gcCollection);
        }
        return mfs;
    }
}

