"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Protocol Buffers for metrics classes, used in the Fn API, Job API, and by SDKs.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class MonitoringInfoSpec(google.protobuf.message.Message):
    """A specification for describing a well known MonitoringInfo.

    All specifications are uniquely identified by the urn.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URN_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    REQUIRED_LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """Defines the semantic meaning of the metric or monitored state.

    See MonitoringInfoSpecs.Enum for the set of well known metrics/monitored
    state.
    """
    type: builtins.str
    """Defines the required encoding and aggregation method for the payload.

    See MonitoringInfoTypeUrns.Enum for the set of well known types.
    """
    @property
    def required_labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of required labels for the specified urn and type."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Annotation]:
        """Extra non functional parts of the spec for descriptive purposes.
        i.e. description, units, etc.
        """
    def __init__(
        self,
        *,
        urn: builtins.str | None = ...,
        type: builtins.str | None = ...,
        required_labels: collections.abc.Iterable[builtins.str] | None = ...,
        annotations: collections.abc.Iterable[global___Annotation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "required_labels", b"required_labels", "type", b"type", "urn", b"urn"]) -> None: ...

global___MonitoringInfoSpec = MonitoringInfoSpec

@typing_extensions.final
class Annotation(google.protobuf.message.Message):
    """The key name and value string of MonitoringInfo annotations."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str | None = ...,
        value: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

global___Annotation = Annotation

@typing_extensions.final
class MonitoringInfoSpecs(google.protobuf.message.Message):
    """A set of well known MonitoringInfo specifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MonitoringInfoSpecs._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        USER_SUM_INT64: MonitoringInfoSpecs._Enum.ValueType  # 0
        """Represents an integer counter where values are summed across bundles."""
        USER_SUM_DOUBLE: MonitoringInfoSpecs._Enum.ValueType  # 1
        """Represents a double counter where values are summed across bundles."""
        USER_DISTRIBUTION_INT64: MonitoringInfoSpecs._Enum.ValueType  # 2
        """Represents a distribution of an integer value where:
          - count: represents the number of values seen across all bundles
          - sum: represents the total of the value across all bundles
          - min: represents the smallest value seen across all bundles
          - max: represents the largest value seen across all bundles
        """
        USER_DISTRIBUTION_DOUBLE: MonitoringInfoSpecs._Enum.ValueType  # 3
        """Represents a distribution of a double value where:
          - count: represents the number of values seen across all bundles
          - sum: represents the total of the value across all bundles
          - min: represents the smallest value seen across all bundles
          - max: represents the largest value seen across all bundles
        """
        USER_LATEST_INT64: MonitoringInfoSpecs._Enum.ValueType  # 4
        """Represents the latest seen integer value. The timestamp is used to
        provide an "ordering" over multiple values to determine which is the
        latest.
        """
        USER_LATEST_DOUBLE: MonitoringInfoSpecs._Enum.ValueType  # 5
        """Represents the latest seen double value. The timestamp is used to
        provide an "ordering" over multiple values to determine which is the
        latest.
        """
        USER_TOP_N_INT64: MonitoringInfoSpecs._Enum.ValueType  # 6
        """Represents the largest set of integer values seen across bundles."""
        USER_TOP_N_DOUBLE: MonitoringInfoSpecs._Enum.ValueType  # 7
        """Represents the largest set of double values seen across bundles."""
        USER_BOTTOM_N_INT64: MonitoringInfoSpecs._Enum.ValueType  # 8
        """Represents the smallest set of integer values seen across bundles."""
        USER_BOTTOM_N_DOUBLE: MonitoringInfoSpecs._Enum.ValueType  # 9
        """Represents the smallest set of double values seen across bundles."""
        USER_SET_STRING: MonitoringInfoSpecs._Enum.ValueType  # 21
        """Represents a set of strings seen across bundles."""
        USER_BOUNDED_TRIE: MonitoringInfoSpecs._Enum.ValueType  # 22
        """Represents a set of strings seen across bundles."""
        ELEMENT_COUNT: MonitoringInfoSpecs._Enum.ValueType  # 10
        """General monitored state information which contains structured information
        which does not fit into a typical metric format. See MonitoringTableData
        for more details.

        TODO(https://github.com/apache/beam/issues/20122): Support monitored state.

        USER_MONITORING_TABLE = XX [(monitoring_info_spec) = {
          urn: "beam:metric:user:v1",
          type: "beam:metrics:monitoring_table:v1",
          required_labels: ["PTRANSFORM", "NAMESPACE", "NAME"],
          annotations: [{
            key: "description",
            value: "URN utilized to report user monitoring data."
          }]
        }];
        """
        SAMPLED_BYTE_SIZE: MonitoringInfoSpecs._Enum.ValueType  # 11
        START_BUNDLE_MSECS: MonitoringInfoSpecs._Enum.ValueType  # 12
        PROCESS_BUNDLE_MSECS: MonitoringInfoSpecs._Enum.ValueType  # 13
        FINISH_BUNDLE_MSECS: MonitoringInfoSpecs._Enum.ValueType  # 14
        TOTAL_MSECS: MonitoringInfoSpecs._Enum.ValueType  # 15
        WORK_REMAINING: MonitoringInfoSpecs._Enum.ValueType  # 16
        """All values reported across all beam:metric:ptransform_progress:.*:v1
        metrics are of the same magnitude.
        """
        WORK_COMPLETED: MonitoringInfoSpecs._Enum.ValueType  # 17
        """All values reported across all beam:metric:ptransform_progress:.*:v1
        metrics are of the same magnitude.
        """
        DATA_CHANNEL_READ_INDEX: MonitoringInfoSpecs._Enum.ValueType  # 18
        """The (0-based) index of the latest item processed from the data channel.
        This gives an indication of the SDKs progress through the data channel,
        and is a lower bound on where it is able to split.
        For an SDK that processes items sequentially, this is equivalently the
        number of items fully processed (or -1 if processing has not yet started).
        """
        API_REQUEST_COUNT: MonitoringInfoSpecs._Enum.ValueType  # 19
        API_REQUEST_LATENCIES: MonitoringInfoSpecs._Enum.ValueType  # 20
        USER_HISTOGRAM: MonitoringInfoSpecs._Enum.ValueType  # 23

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    USER_SUM_INT64: MonitoringInfoSpecs.Enum.ValueType  # 0
    """Represents an integer counter where values are summed across bundles."""
    USER_SUM_DOUBLE: MonitoringInfoSpecs.Enum.ValueType  # 1
    """Represents a double counter where values are summed across bundles."""
    USER_DISTRIBUTION_INT64: MonitoringInfoSpecs.Enum.ValueType  # 2
    """Represents a distribution of an integer value where:
      - count: represents the number of values seen across all bundles
      - sum: represents the total of the value across all bundles
      - min: represents the smallest value seen across all bundles
      - max: represents the largest value seen across all bundles
    """
    USER_DISTRIBUTION_DOUBLE: MonitoringInfoSpecs.Enum.ValueType  # 3
    """Represents a distribution of a double value where:
      - count: represents the number of values seen across all bundles
      - sum: represents the total of the value across all bundles
      - min: represents the smallest value seen across all bundles
      - max: represents the largest value seen across all bundles
    """
    USER_LATEST_INT64: MonitoringInfoSpecs.Enum.ValueType  # 4
    """Represents the latest seen integer value. The timestamp is used to
    provide an "ordering" over multiple values to determine which is the
    latest.
    """
    USER_LATEST_DOUBLE: MonitoringInfoSpecs.Enum.ValueType  # 5
    """Represents the latest seen double value. The timestamp is used to
    provide an "ordering" over multiple values to determine which is the
    latest.
    """
    USER_TOP_N_INT64: MonitoringInfoSpecs.Enum.ValueType  # 6
    """Represents the largest set of integer values seen across bundles."""
    USER_TOP_N_DOUBLE: MonitoringInfoSpecs.Enum.ValueType  # 7
    """Represents the largest set of double values seen across bundles."""
    USER_BOTTOM_N_INT64: MonitoringInfoSpecs.Enum.ValueType  # 8
    """Represents the smallest set of integer values seen across bundles."""
    USER_BOTTOM_N_DOUBLE: MonitoringInfoSpecs.Enum.ValueType  # 9
    """Represents the smallest set of double values seen across bundles."""
    USER_SET_STRING: MonitoringInfoSpecs.Enum.ValueType  # 21
    """Represents a set of strings seen across bundles."""
    USER_BOUNDED_TRIE: MonitoringInfoSpecs.Enum.ValueType  # 22
    """Represents a set of strings seen across bundles."""
    ELEMENT_COUNT: MonitoringInfoSpecs.Enum.ValueType  # 10
    """General monitored state information which contains structured information
    which does not fit into a typical metric format. See MonitoringTableData
    for more details.

    TODO(https://github.com/apache/beam/issues/20122): Support monitored state.

    USER_MONITORING_TABLE = XX [(monitoring_info_spec) = {
      urn: "beam:metric:user:v1",
      type: "beam:metrics:monitoring_table:v1",
      required_labels: ["PTRANSFORM", "NAMESPACE", "NAME"],
      annotations: [{
        key: "description",
        value: "URN utilized to report user monitoring data."
      }]
    }];
    """
    SAMPLED_BYTE_SIZE: MonitoringInfoSpecs.Enum.ValueType  # 11
    START_BUNDLE_MSECS: MonitoringInfoSpecs.Enum.ValueType  # 12
    PROCESS_BUNDLE_MSECS: MonitoringInfoSpecs.Enum.ValueType  # 13
    FINISH_BUNDLE_MSECS: MonitoringInfoSpecs.Enum.ValueType  # 14
    TOTAL_MSECS: MonitoringInfoSpecs.Enum.ValueType  # 15
    WORK_REMAINING: MonitoringInfoSpecs.Enum.ValueType  # 16
    """All values reported across all beam:metric:ptransform_progress:.*:v1
    metrics are of the same magnitude.
    """
    WORK_COMPLETED: MonitoringInfoSpecs.Enum.ValueType  # 17
    """All values reported across all beam:metric:ptransform_progress:.*:v1
    metrics are of the same magnitude.
    """
    DATA_CHANNEL_READ_INDEX: MonitoringInfoSpecs.Enum.ValueType  # 18
    """The (0-based) index of the latest item processed from the data channel.
    This gives an indication of the SDKs progress through the data channel,
    and is a lower bound on where it is able to split.
    For an SDK that processes items sequentially, this is equivalently the
    number of items fully processed (or -1 if processing has not yet started).
    """
    API_REQUEST_COUNT: MonitoringInfoSpecs.Enum.ValueType  # 19
    API_REQUEST_LATENCIES: MonitoringInfoSpecs.Enum.ValueType  # 20
    USER_HISTOGRAM: MonitoringInfoSpecs.Enum.ValueType  # 23

    def __init__(
        self,
    ) -> None: ...

global___MonitoringInfoSpecs = MonitoringInfoSpecs

@typing_extensions.final
class MonitoringInfoLabelProps(google.protobuf.message.Message):
    """A set of properties for the MonitoringInfoLabel, this is useful to obtain
    the proper label string for the MonitoringInfoLabel.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The label key to use in the MonitoringInfo labels map."""
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___MonitoringInfoLabelProps = MonitoringInfoLabelProps

@typing_extensions.final
class MonitoringInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MonitoringInfoLabels:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MonitoringInfoLabelsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MonitoringInfo._MonitoringInfoLabels.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRANSFORM: MonitoringInfo._MonitoringInfoLabels.ValueType  # 0
        """The values used for TRANSFORM, PCOLLECTION, WINDOWING_STRATEGY
        CODER, ENVIRONMENT, etc. must always match the keys used to
        refer to them. For actively processed bundles, these should match the
        values within the ProcessBundleDescriptor. For job management APIs,
        these should match values within the original pipeline representation.
        """
        PCOLLECTION: MonitoringInfo._MonitoringInfoLabels.ValueType  # 1
        WINDOWING_STRATEGY: MonitoringInfo._MonitoringInfoLabels.ValueType  # 2
        CODER: MonitoringInfo._MonitoringInfoLabels.ValueType  # 3
        ENVIRONMENT: MonitoringInfo._MonitoringInfoLabels.ValueType  # 4
        NAMESPACE: MonitoringInfo._MonitoringInfoLabels.ValueType  # 5
        NAME: MonitoringInfo._MonitoringInfoLabels.ValueType  # 6
        SERVICE: MonitoringInfo._MonitoringInfoLabels.ValueType  # 7
        METHOD: MonitoringInfo._MonitoringInfoLabels.ValueType  # 8
        RESOURCE: MonitoringInfo._MonitoringInfoLabels.ValueType  # 9
        STATUS: MonitoringInfo._MonitoringInfoLabels.ValueType  # 10
        BIGQUERY_PROJECT_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 11
        BIGQUERY_DATASET: MonitoringInfo._MonitoringInfoLabels.ValueType  # 12
        BIGQUERY_TABLE: MonitoringInfo._MonitoringInfoLabels.ValueType  # 13
        BIGQUERY_VIEW: MonitoringInfo._MonitoringInfoLabels.ValueType  # 14
        BIGQUERY_QUERY_NAME: MonitoringInfo._MonitoringInfoLabels.ValueType  # 15
        GCS_BUCKET: MonitoringInfo._MonitoringInfoLabels.ValueType  # 16
        GCS_PROJECT_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 17
        DATASTORE_PROJECT: MonitoringInfo._MonitoringInfoLabels.ValueType  # 18
        DATASTORE_NAMESPACE: MonitoringInfo._MonitoringInfoLabels.ValueType  # 19
        BIGTABLE_PROJECT_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 20
        INSTANCE_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 21
        TABLE_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 22
        SPANNER_PROJECT_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 23
        SPANNER_DATABASE_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 24
        SPANNER_TABLE_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 25
        SPANNER_INSTANCE_ID: MonitoringInfo._MonitoringInfoLabels.ValueType  # 26
        SPANNER_QUERY_NAME: MonitoringInfo._MonitoringInfoLabels.ValueType  # 27
        PER_WORKER_METRIC: MonitoringInfo._MonitoringInfoLabels.ValueType  # 28
        """Label which if has a "true" value indicates that the metric is intended 
        to be aggregated per-worker.
        """

    class MonitoringInfoLabels(_MonitoringInfoLabels, metaclass=_MonitoringInfoLabelsEnumTypeWrapper): ...
    TRANSFORM: MonitoringInfo.MonitoringInfoLabels.ValueType  # 0
    """The values used for TRANSFORM, PCOLLECTION, WINDOWING_STRATEGY
    CODER, ENVIRONMENT, etc. must always match the keys used to
    refer to them. For actively processed bundles, these should match the
    values within the ProcessBundleDescriptor. For job management APIs,
    these should match values within the original pipeline representation.
    """
    PCOLLECTION: MonitoringInfo.MonitoringInfoLabels.ValueType  # 1
    WINDOWING_STRATEGY: MonitoringInfo.MonitoringInfoLabels.ValueType  # 2
    CODER: MonitoringInfo.MonitoringInfoLabels.ValueType  # 3
    ENVIRONMENT: MonitoringInfo.MonitoringInfoLabels.ValueType  # 4
    NAMESPACE: MonitoringInfo.MonitoringInfoLabels.ValueType  # 5
    NAME: MonitoringInfo.MonitoringInfoLabels.ValueType  # 6
    SERVICE: MonitoringInfo.MonitoringInfoLabels.ValueType  # 7
    METHOD: MonitoringInfo.MonitoringInfoLabels.ValueType  # 8
    RESOURCE: MonitoringInfo.MonitoringInfoLabels.ValueType  # 9
    STATUS: MonitoringInfo.MonitoringInfoLabels.ValueType  # 10
    BIGQUERY_PROJECT_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 11
    BIGQUERY_DATASET: MonitoringInfo.MonitoringInfoLabels.ValueType  # 12
    BIGQUERY_TABLE: MonitoringInfo.MonitoringInfoLabels.ValueType  # 13
    BIGQUERY_VIEW: MonitoringInfo.MonitoringInfoLabels.ValueType  # 14
    BIGQUERY_QUERY_NAME: MonitoringInfo.MonitoringInfoLabels.ValueType  # 15
    GCS_BUCKET: MonitoringInfo.MonitoringInfoLabels.ValueType  # 16
    GCS_PROJECT_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 17
    DATASTORE_PROJECT: MonitoringInfo.MonitoringInfoLabels.ValueType  # 18
    DATASTORE_NAMESPACE: MonitoringInfo.MonitoringInfoLabels.ValueType  # 19
    BIGTABLE_PROJECT_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 20
    INSTANCE_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 21
    TABLE_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 22
    SPANNER_PROJECT_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 23
    SPANNER_DATABASE_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 24
    SPANNER_TABLE_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 25
    SPANNER_INSTANCE_ID: MonitoringInfo.MonitoringInfoLabels.ValueType  # 26
    SPANNER_QUERY_NAME: MonitoringInfo.MonitoringInfoLabels.ValueType  # 27
    PER_WORKER_METRIC: MonitoringInfo.MonitoringInfoLabels.ValueType  # 28
    """Label which if has a "true" value indicates that the metric is intended 
    to be aggregated per-worker.
    """

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    URN_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """(Required) Defines the semantic meaning of the metric or monitored state.

    See MonitoringInfoSpecs.Enum for the set of well known metrics/monitored
    state.
    """
    type: builtins.str
    """(Required) Defines the encoding and aggregation method for the payload.

    See MonitoringInfoTypeUrns.Enum for the set of well known types.
    """
    payload: builtins.bytes
    """(Required) The metric or monitored state encoded as per the specification
    defined by the type.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A set of key and value labels which define the scope of the metric. For
        well known URNs, the set of required labels is provided by the associated
        MonitoringInfoSpec.

        Either a well defined entity id for matching the enum names in
        the MonitoringInfoLabels enum or any arbitrary label
        set by a custom metric or user metric.

        A monitoring system is expected to be able to aggregate the metrics
        together for all updates having the same URN and labels. Some systems such
        as Stackdriver will be able to aggregate the metrics using a subset of the
        provided labels
        """
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """This indicates the start of the time range over which this value was
        measured.
        This is needed by some external metric aggregation services
        to indicate when the reporter of the metric first began collecting the
        cumulative value for the timeseries.
        If the SDK Harness restarts, it should reset the start_time, and reset
        the collection of cumulative metrics (i.e. start to count again from 0).
        HarnessMonitoringInfos should set this start_time once, when the
        MonitoringInfo is first reported.
        ProcessBundle MonitoringInfos should set a start_time for each bundle.
        """
    def __init__(
        self,
        *,
        urn: builtins.str | None = ...,
        type: builtins.str | None = ...,
        payload: builtins.bytes | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels", "payload", b"payload", "start_time", b"start_time", "type", b"type", "urn", b"urn"]) -> None: ...

global___MonitoringInfo = MonitoringInfo

@typing_extensions.final
class MonitoringInfoTypeUrns(google.protobuf.message.Message):
    """A set of well known URNs that specify the encoding and aggregation method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MonitoringInfoTypeUrns._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUM_INT64_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 0
        """Represents an integer counter where values are summed across bundles.

        Encoding: <value>
          - value: beam:coder:varint:v1
        """
        SUM_DOUBLE_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 1
        """Represents a double counter where values are summed across bundles.

        Encoding: <value>
          value: beam:coder:double:v1
        """
        DISTRIBUTION_INT64_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 2
        """Represents a distribution of an integer value where:
          - count: represents the number of values seen across all bundles
          - sum: represents the total of the value across all bundles
          - min: represents the smallest value seen across all bundles
          - max: represents the largest value seen across all bundles

        Encoding: <count><sum><min><max>
          - count: beam:coder:varint:v1
          - sum:   beam:coder:varint:v1
          - min:   beam:coder:varint:v1
          - max:   beam:coder:varint:v1
        """
        DISTRIBUTION_DOUBLE_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 3
        """Represents a distribution of a double value where:
          - count: represents the number of values seen across all bundles
          - sum: represents the total of the value across all bundles
          - min: represents the smallest value seen across all bundles
          - max: represents the largest value seen across all bundles

        Encoding: <count><sum><min><max>
          - count: beam:coder:varint:v1
          - sum:   beam:coder:double:v1
          - min:   beam:coder:double:v1
          - max:   beam:coder:double:v1
        """
        LATEST_INT64_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 4
        """Represents the latest seen integer value. The timestamp is used to
        provide an "ordering" over multiple values to determine which is the
        latest.

        Encoding: <timestamp><value>
          - timestamp: beam:coder:varint:v1     (milliseconds since epoch)
          - value:     beam:coder:varint:v1
        """
        LATEST_DOUBLE_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 5
        """Represents the latest seen double value. The timestamp is used to
        provide an "ordering" over multiple values to determine which is the
        latest.

        Encoding: <timestamp><value>
          - timestamp: beam:coder:varint:v1     (milliseconds since epoch)
          - value:     beam:coder:double:v1
        """
        TOP_N_INT64_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 6
        """Represents the largest set of integer values seen across bundles.

        Encoding: <iter><value1><value2>...<valueN></iter>
          - iter:   beam:coder:iterable:v1
          - valueX: beam:coder:varint:v1
        """
        TOP_N_DOUBLE_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 7
        """Represents the largest set of double values seen across bundles.

        Encoding: <iter><value1><value2>...<valueN></iter>
          - iter:   beam:coder:iterable:v1
          - valueX: beam:coder<beam:coder:double:v1
        """
        BOTTOM_N_INT64_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 8
        """Represents the smallest set of integer values seen across bundles.

        Encoding: <iter><value1><value2>...<valueN></iter>
          - iter:   beam:coder:iterable:v1
          - valueX: beam:coder:varint:v1
        """
        BOTTOM_N_DOUBLE_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 9
        """Represents the smallest set of double values seen across bundles.

        Encoding: <iter><value1><value2>...<valueN></iter>
          - iter:   beam:coder:iterable:v1
          - valueX: beam:coder:double:v1
        """
        PROGRESS_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 10
        """Encoding: <iter><value1><value2>...<valueN></iter>
          - iter:   beam:coder:iterable:v1
          - valueX: beam:coder:double:v1
        """
        SET_STRING_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 11
        """Represents a set of strings.

        Encoding: <iter><value1><value2>...<valueN></iter>
          - iter:   beam:coder:iterable:v1
          - valueX: beam:coder:stringutf8:v1
        """
        BOUNDED_TRIE_TYPE: MonitoringInfoTypeUrns._Enum.ValueType  # 12
        """Represents a bounded trie of strings.

        Encoding: BoundedTrie proto
        """
        HISTOGRAM: MonitoringInfoTypeUrns._Enum.ValueType  # 13
        """Represents a histogram."""

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    SUM_INT64_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 0
    """Represents an integer counter where values are summed across bundles.

    Encoding: <value>
      - value: beam:coder:varint:v1
    """
    SUM_DOUBLE_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 1
    """Represents a double counter where values are summed across bundles.

    Encoding: <value>
      value: beam:coder:double:v1
    """
    DISTRIBUTION_INT64_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 2
    """Represents a distribution of an integer value where:
      - count: represents the number of values seen across all bundles
      - sum: represents the total of the value across all bundles
      - min: represents the smallest value seen across all bundles
      - max: represents the largest value seen across all bundles

    Encoding: <count><sum><min><max>
      - count: beam:coder:varint:v1
      - sum:   beam:coder:varint:v1
      - min:   beam:coder:varint:v1
      - max:   beam:coder:varint:v1
    """
    DISTRIBUTION_DOUBLE_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 3
    """Represents a distribution of a double value where:
      - count: represents the number of values seen across all bundles
      - sum: represents the total of the value across all bundles
      - min: represents the smallest value seen across all bundles
      - max: represents the largest value seen across all bundles

    Encoding: <count><sum><min><max>
      - count: beam:coder:varint:v1
      - sum:   beam:coder:double:v1
      - min:   beam:coder:double:v1
      - max:   beam:coder:double:v1
    """
    LATEST_INT64_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 4
    """Represents the latest seen integer value. The timestamp is used to
    provide an "ordering" over multiple values to determine which is the
    latest.

    Encoding: <timestamp><value>
      - timestamp: beam:coder:varint:v1     (milliseconds since epoch)
      - value:     beam:coder:varint:v1
    """
    LATEST_DOUBLE_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 5
    """Represents the latest seen double value. The timestamp is used to
    provide an "ordering" over multiple values to determine which is the
    latest.

    Encoding: <timestamp><value>
      - timestamp: beam:coder:varint:v1     (milliseconds since epoch)
      - value:     beam:coder:double:v1
    """
    TOP_N_INT64_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 6
    """Represents the largest set of integer values seen across bundles.

    Encoding: <iter><value1><value2>...<valueN></iter>
      - iter:   beam:coder:iterable:v1
      - valueX: beam:coder:varint:v1
    """
    TOP_N_DOUBLE_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 7
    """Represents the largest set of double values seen across bundles.

    Encoding: <iter><value1><value2>...<valueN></iter>
      - iter:   beam:coder:iterable:v1
      - valueX: beam:coder<beam:coder:double:v1
    """
    BOTTOM_N_INT64_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 8
    """Represents the smallest set of integer values seen across bundles.

    Encoding: <iter><value1><value2>...<valueN></iter>
      - iter:   beam:coder:iterable:v1
      - valueX: beam:coder:varint:v1
    """
    BOTTOM_N_DOUBLE_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 9
    """Represents the smallest set of double values seen across bundles.

    Encoding: <iter><value1><value2>...<valueN></iter>
      - iter:   beam:coder:iterable:v1
      - valueX: beam:coder:double:v1
    """
    PROGRESS_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 10
    """Encoding: <iter><value1><value2>...<valueN></iter>
      - iter:   beam:coder:iterable:v1
      - valueX: beam:coder:double:v1
    """
    SET_STRING_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 11
    """Represents a set of strings.

    Encoding: <iter><value1><value2>...<valueN></iter>
      - iter:   beam:coder:iterable:v1
      - valueX: beam:coder:stringutf8:v1
    """
    BOUNDED_TRIE_TYPE: MonitoringInfoTypeUrns.Enum.ValueType  # 12
    """Represents a bounded trie of strings.

    Encoding: BoundedTrie proto
    """
    HISTOGRAM: MonitoringInfoTypeUrns.Enum.ValueType  # 13
    """Represents a histogram."""

    def __init__(
        self,
    ) -> None: ...

global___MonitoringInfoTypeUrns = MonitoringInfoTypeUrns

@typing_extensions.final
class BoundedTrieNode(google.protobuf.message.Message):
    """A single node in a BoundedTrie."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ChildrenEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___BoundedTrieNode: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___BoundedTrieNode | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRUNCATED_FIELD_NUMBER: builtins.int
    CHILDREN_FIELD_NUMBER: builtins.int
    truncated: builtins.bool
    """Whether this node has been truncated.
    A truncated leaf represents possibly many children with the same prefix.
    """
    @property
    def children(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___BoundedTrieNode]:
        """Children of this node.  Must be empty if truncated is true."""
    def __init__(
        self,
        *,
        truncated: builtins.bool | None = ...,
        children: collections.abc.Mapping[builtins.str, global___BoundedTrieNode] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["children", b"children", "truncated", b"truncated"]) -> None: ...

global___BoundedTrieNode = BoundedTrieNode

@typing_extensions.final
class BoundedTrie(google.protobuf.message.Message):
    """The message type used for encoding metrics of type bounded trie."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOUND_FIELD_NUMBER: builtins.int
    ROOT_FIELD_NUMBER: builtins.int
    SINGLETON_FIELD_NUMBER: builtins.int
    bound: builtins.int
    """The maximum number of elements to store before truncation."""
    @property
    def root(self) -> global___BoundedTrieNode:
        """A compact representation of all the elements in this trie."""
    @property
    def singleton(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A more efficient representation for metrics consisting of a single value."""
    def __init__(
        self,
        *,
        bound: builtins.int | None = ...,
        root: global___BoundedTrieNode | None = ...,
        singleton: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["root", b"root"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bound", b"bound", "root", b"root", "singleton", b"singleton"]) -> None: ...

global___BoundedTrie = BoundedTrie

@typing_extensions.final
class HistogramValue(google.protobuf.message.Message):
    """The message type used for encoding Histogram Data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class BucketOptions(google.protobuf.message.Message):
        """`BucketOptions` describes the bucket boundaries used in the histogram."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class Linear(google.protobuf.message.Message):
            """Linear buckets with the following boundaries for indices in 0 to n-1.
            - i in [0, n-1]:  [start + (i)*width, start + (i+1)*width)
            """

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            NUMBER_OF_BUCKETS_FIELD_NUMBER: builtins.int
            WIDTH_FIELD_NUMBER: builtins.int
            START_FIELD_NUMBER: builtins.int
            number_of_buckets: builtins.int
            """Must be greater than 0.

            (-- api-linter: core::0140::prepositions=disabled
                aip.dev/not-precedent: `bucket_count` would cause confusion with
                `bucket_counts` field --)
            """
            width: builtins.float
            """Distance between bucket boundaries. Must be greater than 0."""
            start: builtins.float
            """Lower bound of the first bucket."""
            def __init__(
                self,
                *,
                number_of_buckets: builtins.int | None = ...,
                width: builtins.float | None = ...,
                start: builtins.float | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["_number_of_buckets", b"_number_of_buckets", "_start", b"_start", "_width", b"_width", "number_of_buckets", b"number_of_buckets", "start", b"start", "width", b"width"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["_number_of_buckets", b"_number_of_buckets", "_start", b"_start", "_width", b"_width", "number_of_buckets", b"number_of_buckets", "start", b"start", "width", b"width"]) -> None: ...
            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal["_number_of_buckets", b"_number_of_buckets"]) -> typing_extensions.Literal["number_of_buckets"] | None: ...
            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal["_start", b"_start"]) -> typing_extensions.Literal["start"] | None: ...
            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal["_width", b"_width"]) -> typing_extensions.Literal["width"] | None: ...

        @typing_extensions.final
        class Base2Exponent(google.protobuf.message.Message):
            """Exponential buckets where the growth factor between buckets is
            `2**(2**-scale)`. e.g. for `scale=1` growth factor is
            `2**(2**(-1))=sqrt(2)`. `n` buckets will have the following boundaries.
             - 0th: [0, gf)
             - i in [1, n-1]: [gf^(i), gf^(i+1))
            """

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            NUMBER_OF_BUCKETS_FIELD_NUMBER: builtins.int
            SCALE_FIELD_NUMBER: builtins.int
            number_of_buckets: builtins.int
            """Must be greater than 0.

            (-- api-linter: core::0140::prepositions=disabled
                aip.dev/not-precedent: `bucket_count` would cause confusion with
                `bucket_counts` field --)
            """
            scale: builtins.int
            """Must be between -3 and 3. This forces the growth factor of the bucket
            boundaries to be between `2^(1/8)` and `256`.
            """
            def __init__(
                self,
                *,
                number_of_buckets: builtins.int | None = ...,
                scale: builtins.int | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["_number_of_buckets", b"_number_of_buckets", "_scale", b"_scale", "number_of_buckets", b"number_of_buckets", "scale", b"scale"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["_number_of_buckets", b"_number_of_buckets", "_scale", b"_scale", "number_of_buckets", b"number_of_buckets", "scale", b"scale"]) -> None: ...
            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal["_number_of_buckets", b"_number_of_buckets"]) -> typing_extensions.Literal["number_of_buckets"] | None: ...
            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal["_scale", b"_scale"]) -> typing_extensions.Literal["scale"] | None: ...

        LINEAR_FIELD_NUMBER: builtins.int
        EXPONENTIAL_FIELD_NUMBER: builtins.int
        @property
        def linear(self) -> global___HistogramValue.BucketOptions.Linear:
            """Bucket boundaries grow linearly."""
        @property
        def exponential(self) -> global___HistogramValue.BucketOptions.Base2Exponent:
            """Bucket boundaries grow exponentially."""
        def __init__(
            self,
            *,
            linear: global___HistogramValue.BucketOptions.Linear | None = ...,
            exponential: global___HistogramValue.BucketOptions.Base2Exponent | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["bucket_type", b"bucket_type", "exponential", b"exponential", "linear", b"linear"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["bucket_type", b"bucket_type", "exponential", b"exponential", "linear", b"linear"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["bucket_type", b"bucket_type"]) -> typing_extensions.Literal["linear", "exponential"] | None: ...

    COUNT_FIELD_NUMBER: builtins.int
    BUCKET_OPTIONS_FIELD_NUMBER: builtins.int
    BUCKET_COUNTS_FIELD_NUMBER: builtins.int
    count: builtins.int
    """Number of values recorded in this histogram."""
    @property
    def bucket_options(self) -> global___HistogramValue.BucketOptions:
        """Describes the bucket boundaries used in the histogram."""
    @property
    def bucket_counts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The number of values in each bucket of the histogram, as described in
        `bucket_options`. `bucket_counts` should contain N values, where N is the
        number of buckets specified in `bucket_options`. If `bucket_counts` has
        fewer than N values, the remaining values are assumed to be 0.
        """
    def __init__(
        self,
        *,
        count: builtins.int | None = ...,
        bucket_options: global___HistogramValue.BucketOptions | None = ...,
        bucket_counts: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_bucket_options", b"_bucket_options", "_count", b"_count", "bucket_options", b"bucket_options", "count", b"count"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_bucket_options", b"_bucket_options", "_count", b"_count", "bucket_counts", b"bucket_counts", "bucket_options", b"bucket_options", "count", b"count"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_bucket_options", b"_bucket_options"]) -> typing_extensions.Literal["bucket_options"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_count", b"_count"]) -> typing_extensions.Literal["count"] | None: ...

global___HistogramValue = HistogramValue

LABEL_PROPS_FIELD_NUMBER: builtins.int
MONITORING_INFO_SPEC_FIELD_NUMBER: builtins.int
label_props: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.EnumValueOptions, global___MonitoringInfoLabelProps]
"""From: commit 0x7970544."""
monitoring_info_spec: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.EnumValueOptions, global___MonitoringInfoSpec]
"""Enum extension to store the MonitoringInfoSpecs."""
